------------------------------------------------------------------------------
-- Align Tools Vertically
--
-- tool script
--
-- This script will align the selected tools so they share the same position 
-- on the X axis as the tool that executed the script.
--
-- written by : eyeon Software (sdk@eyeonline.com)
-- written    : May. 12th, 2008

------------------------------------------------------------------------------

local flow = comp.CurrentFrame.FlowView -- get current flowview

local x, y = flow:GetPos(tool) -- get current tools position

comp:StartUndo("Align tools vertically")

for i, t in pairs(comp:GetToolList(true)) do -- for every selected tool
	cur_x, cur_y = flow:GetPos(t) -- get tools position
	
	flow:SetPos(t, x, cur_y) -- set the new position
end

flow:Refresh()
comp:EndUndo(true)

